
import type { Metadata } from 'next';

export const metadata: Metadata = {
    title: 'Terms of Use | RiteClick Technology',
    description: 'Terms of Use for RiteClick Technology. Read our terms before using our services.',
};

export default function TermsOfUsePage() {
  return (
    <div className="container py-12 md:py-24">
      <article className="prose prose-lg mx-auto max-w-4xl">
        <h1 className="text-3xl md:text-5xl font-bold font-headline mb-8 text-center">RiteClick Technology Terms of Use</h1>
        <p>Welcome to RiteClick Technology! By accessing or using our online platforms, including our website, mobile applications, APIs, or related services (collectively, the “Services”), you agree to be bound by these Terms of Use (“Terms”). If you do not agree with these Terms, you should not use the Services.</p>
        <p>These Terms govern your use of the Services provided by RiteClick Technology, together with subsidiaries and international affiliates (“RiteClick Technology”, “we”, “us”). Please read these Terms carefully.</p>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">1. Using the Services</h2>
          <h3 className="text-xl font-bold font-headline mt-4">1.1 Eligibility</h3>
          <p>To use our Services, you must be at least 13 years old or have reached the age of majority in your jurisdiction, and have the power and authority to enter into these Terms. You are not permitted to use the Services if you have been banned by RiteClick Technology from using the Services.</p>
          <h3 className="text-xl font-bold font-headline mt-4">1.2 Account Creation</h3>
          <p>To access certain features of the Services, you must create an account. When you create or update your account, you must provide accurate and complete information. You are responsible for maintaining the confidentiality of your account credentials, and you agree to notify us immediately of any unauthorized use of your account. You are responsible for all activities that occur under your account.</p>
          <h3 className="text-xl font-bold font-headline mt-4">1.3 Course Enrollment</h3>
          <p>When you enroll in a course or program on RiteClick Technology, you are granted a limited, non-exclusive, non-transferable license to access and view the content for which you have paid all required fees, solely for your personal, non-commercial, educational purposes through the Services, in accordance with these Terms and any conditions or restrictions associated with a particular course or feature of our Services. All other uses are expressly prohibited without our express written consent.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">2. Content and Behavior Rules</h2>
          <h3 className="text-xl font-bold font-headline mt-4">2.1 User Content</h3>
          <p>The Services enable you to share your content, such as course outlines, course materials, exams, projects, feedback, and other assignments (collectively, “User Content”). You retain all intellectual property rights in, and are responsible for, the User Content you share.</p>
          <h3 className="text-xl font-bold font-headline mt-4">2.2 Content Standards</h3>
          <p>You agree that you will not post any User Content that:</p>
          <ul className="list-disc pl-6 space-y-2 mt-2">
            <li>Violates any applicable law or regulation;</li>
            <li>Infringes the intellectual property rights of others;</li>
            <li>Is harmful, fraudulent, deceptive, threatening, abusive, harassing, defamatory, vulgar, obscene, or otherwise objectionable;</li>
            <li>Promotes or endorses illegal activities;</li>
            <li>Contains advertising or any solicitation.</li>
          </ul>
          <h3 className="text-xl font-bold font-headline mt-4">2.3 Code of Conduct</h3>
          <p>You agree to:</p>
          <ul className="list-disc pl-6 space-y-2 mt-2">
            <li>Use the Services in a manner consistent with these Terms and applicable laws;</li>
            <li>Respect the rights and dignity of others;</li>
            <li>Not engage in any activity that disrupts or interferes with the Services;</li>
            <li>Not impersonate another person or gain unauthorized access to another person’s account.</li>
          </ul>
        </section>
        
        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">3. Intellectual Property</h2>
          <h3 className="text-xl font-bold font-headline mt-4">3.1 RiteClick Technology Content</h3>
          <p>The Services and all content provided by RiteClick Technology, including but not limited to courses, videos, text, graphics, images, and software (collectively, “RiteClick Technology Content”), are the property of RiteClick Technology or its licensors and are protected by copyright, trademark, and other intellectual property laws.</p>
          <h3 className="text-xl font-bold font-headline mt-4">3.2 Limited License</h3>
          <p>Subject to your compliance with these Terms, RiteClick Technology grants you a limited, non-exclusive, non-transferable license to access and use the Services and RiteClick Technology Content for your personal, non-commercial, educational purposes. All other uses are expressly prohibited without our express written consent.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">4. Payments and Refunds</h2>
          <h3 className="text-xl font-bold font-headline mt-4">4.1 Payments</h3>
          <p>You agree to pay the fees for courses and programs that you purchase, and you authorize us to charge your chosen payment method. All fees are payable in advance and are non-refundable except as set forth in our Refund Policy.</p>
          <h3 className="text-xl font-bold font-headline mt-4">4.2 Refunds</h3>
          <p>Our refund policy is available on the RiteClick Technology website. We reserve the right to refuse refunds as stated in our refund policy.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">5. Disclaimers and Limitation of Liability</h2>
          <h3 className="text-xl font-bold font-headline mt-4">5.1 Disclaimers</h3>
          <p>The Services and RiteClick Technology Content are provided on an "as is" and "as available" basis, without warranties of any kind, either express or implied, including, without limitation, warranties of merchantability, fitness for a particular purpose, non-infringement, or that use of the Services will be uninterrupted or error-free.</p>
          <h3 className="text-xl font-bold font-headline mt-4">5.2 Limitation of Liability</h3>
          <p>To the fullest extent permitted by law, RiteClick Technology, its affiliates, officers, employees, agents, suppliers, and licensors shall not be liable for any indirect, incidental, special, consequential, or punitive damages, or any loss of profits or revenues, whether incurred directly or indirectly, or any loss of data, use, goodwill, or other intangible losses, resulting from (a) your use or inability to use the Services; (b) any unauthorized access to or use of our servers and/or any personal information stored therein; (c) any interruption or cessation of transmission to or from the Services; (d) any bugs, viruses, trojan horses, or the like that may be transmitted to or through our Services by any third party; (e) any errors or omissions in any content or for any loss or damage incurred as a result of your use of any content posted, emailed, transmitted, or otherwise made available through the Services; and/or (f) the defamatory, offensive, or illegal conduct of any third party. In no event shall RiteClick Technology’s aggregate liability for all claims relating to the Services exceed the greater of Fifty Thousand Naira (NGN #50,000) or the total amount of fees paid by you to RiteClick Technology for the Services during the past twelve months.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">6. Indemnification</h2>
          <p>You agree to indemnify, defend, and hold harmless RiteClick Technology and its affiliates, and their respective officers, directors, employees, agents, licensors, and suppliers from and against all claims, losses, expenses, damages, and costs, including reasonable attorneys' fees, arising out of or relating to your use of the Services, your violation of these Terms, or your violation of any rights of another.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">7. Governing Law and Dispute Resolution</h2>
          <h3 className="text-xl font-bold font-headline mt-4">7.1 Governing Law</h3>
          <p>These Terms shall be governed by and construed in accordance with the laws of Nigeria, without regard to its conflict of law principles.</p>
          <h3 className="text-xl font-bold font-headline mt-4">7.2 Dispute Resolution</h3>
          <p>Any dispute arising out of or in connection with these Terms or the Services shall be resolved through binding arbitration administered by a mutually agreed-upon arbitration service. The arbitration shall be conducted in Nigeria, in English, and the arbitrator’s decision shall be final and binding. You and RiteClick Technology agree that any dispute resolution proceedings will be conducted only on an individual basis and not in a class, consolidated, or representative action.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">8. General Terms</h2>
          <h3 className="text-xl font-bold font-headline mt-4">8.1 Modifications</h3>
          <p>We may modify these Terms from time to time. If we make material changes to these Terms, we will notify you by email or by posting a notice on our Services before the effective date of the changes. By continuing to use the Services after the changes become effective, you agree to be bound by the revised Terms.</p>
          <h3 className="text-xl font-bold font-headline mt-4">8.2 Severability</h3>
          <p>If any provision of these Terms is found to be invalid or unenforceable, that provision shall be enforced to the maximum extent permissible and the other provisions of these Terms shall remain in full force and effect.</p>
          <h3 className="text-xl font-bold font-headline mt-4">8.3 Waiver</h3>
          <p>No waiver of any term of these Terms shall be deemed a further or continuing waiver of such term or any other term, and RiteClick Technology’s failure to assert any right or provision under these Terms shall not constitute a waiver of such right or provision.</p>
          <h3 className="text-xl font-bold font-headline mt-4">8.4 Entire Agreement</h3>
          <p>These Terms constitute the entire agreement between you and RiteClick Technology regarding the use of the Services and supersede any prior agreements between you and RiteClick Technology relating to your use of the Services.</p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Contact Us</h2>
          <p>If you have any questions about these Terms, please contact us at:</p>
           <address className="not-italic mt-2">
            RiteClick Technology<br />
            Legal Department<br />
            Email: <a href="mailto:info@riteclick.com.ng" className="text-primary hover:underline">info@riteclick.com.ng</a>
          </address>
           <p className="mt-4">Thank you for using RiteClick Technology!</p>
        </section>
      </article>
    </div>
  );
}
