
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Check, LayoutDashboard, TrendingUp, DatabaseZap, Users, MessageCircle, Link as LinkIcon } from 'lucide-react';
import Image from 'next/image';
import type { Metadata } from 'next';
import Link from 'next/link';

export const metadata: Metadata = {
    title: 'Data Analytics Consultancy | RiteClick Technology',
    description: 'Expert data analytics consultancy services to help you unlock insights, drive growth, and make data-driven decisions. We offer dashboarding, predictive analytics, and more.',
};

const services = [
  {
    title: 'Business Intelligence & Dashboarding',
    description: 'We transform your raw data into stunning, interactive dashboards (using Power BI, Tableau) that provide a clear view of your business performance.',
    icon: LayoutDashboard,
    features: ['Custom KPI tracking', 'Sales & Marketing Dashboards', 'Operational Analytics', 'Executive Summaries'],
  },
  {
    title: 'Predictive Analytics & Forecasting',
    description: 'Leverage your historical data to predict future trends, customer behavior, and market changes, giving you a competitive edge.',
    icon: TrendingUp,
    features: ['Sales Forecasting', 'Customer Churn Prediction', 'Demand Planning', 'Sentiment Analysis'],
  },
  {
    title: 'Data Strategy & Governance',
    description: 'Develop a robust data strategy that ensures data quality, security, and compliance, turning your data into a reliable, enterprise-wide asset.',
    icon: DatabaseZap,
    features: ['Data Quality Audits', 'Governance Frameworks', 'Data Architecture Design', 'ETL Pipeline Development'],
  },
  {
    title: 'Customer & Marketing Analytics',
    description: 'Gain a deep understanding of your customers. We analyze behavior to optimize marketing campaigns, improve retention, and personalize experiences.',
    icon: Users,
    features: ['Customer Segmentation', 'Campaign Performance Analysis', 'Lifetime Value (LTV) Modeling', 'Attribution Analysis'],
  },
];

export default function DataAnalyticsConsultancyPage() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="relative w-full py-20 md:py-32 lg:py-40 flex items-center justify-center text-center text-white">
        <Image
          src="/dataanalytics.png"
          alt="Data Analytics Consultancy"
          fill
          priority
          className="object-cover -z-10 brightness-50"
        />
        <div className="container px-4 md:px-6">
          <div className="flex flex-col items-center space-y-4">
            <h1 className="text-4xl font-bold tracking-tighter sm:text-5xl xl:text-6xl/none font-headline">
              Data Analytics Consultancy
            </h1>
            <p className="max-w-[700px] text-lg md:text-xl">
              Unlock the power of your data. We provide expert analysis and clear insights to drive business growth and innovation.
            </p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-secondary">
        <div className="container px-4 md:px-6">
          <div className="text-center">
            <h2 className="text-3xl font-bold tracking-tighter sm:text-5xl font-headline">Our Analytics Services</h2>
            <p className="max-w-[900px] mx-auto text-muted-foreground md:text-xl/relaxed mt-4">
              From strategy to execution, we offer end-to-end data analytics solutions to help you make smarter decisions.
            </p>
          </div>
          <div className="mx-auto grid grid-cols-1 gap-8 py-12 sm:grid-cols-2">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="flex flex-col transition-transform transform hover:-translate-y-2">
                  <CardHeader>
                    <div className="flex items-center gap-4">
                      <div className="bg-primary/10 rounded-full p-3 w-fit">
                        <Icon className="h-8 w-8 text-primary" />
                      </div>
                      <CardTitle className="font-headline text-2xl">{service.title}</CardTitle>
                    </div>
                  </CardHeader>
                  <CardContent className="flex-grow flex flex-col">
                    <p className="text-muted-foreground mb-6">{service.description}</p>
                    <ul className="space-y-3 flex-grow">
                      {service.features.map((feature, fIndex) => (
                         <li key={fIndex} className="flex items-start gap-3">
                            <Check className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                            <span className="text-muted-foreground">{feature}</span>
                        </li>
                      ))}
                    </ul>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-background">
        <div className="container text-center">
            <h2 className="text-3xl md:text-4xl font-bold font-headline">Ready to Unlock Your Data's Potential?</h2>
            <p className="mt-4 max-w-2xl mx-auto text-muted-foreground">
              Let's discuss how our data experts can help you achieve your business objectives. Get in touch for a free consultation.
            </p>
            <div className="mt-8 flex flex-col sm:flex-row items-center justify-center gap-4">
                <Button size="lg" asChild>
                  <Link href="https://calendly.com/riteclick/new-meeting" target="_blank" rel="noopener noreferrer">
                    Schedule a Free Consultation <LinkIcon className="ml-2" />
                  </Link>
                </Button>
                <Button size="lg" variant="outline" asChild>
                    <a href="https://wa.me/2349115572489" target="_blank" rel="noopener noreferrer">
                        <MessageCircle className="mr-2" /> Chat on WhatsApp
                    </a>
                </Button>
            </div>
        </div>
      </section>
    </div>
  );
}
