
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Check, Cloudy, Rocket, ServerCog, GitMerge, MessageCircle, DatabaseZap, BrainCircuit, Link as LinkIcon } from 'lucide-react';
import Image from 'next/image';
import type { Metadata } from 'next';
import Link from 'next/link';

export const metadata: Metadata = {
    title: 'Cloud Consultancy Services | RiteClick Technology',
    description: 'Expert cloud consultancy for AWS, Google Cloud, and Azure. We offer cloud strategy, migration, cloud-native development, and DevOps automation to scale your business.',
};

const services = [
  {
    title: 'Multi-Cloud Strategy (AWS, GCP, Azure)',
    description: 'We help you design and implement a robust multi-cloud strategy that leverages the strengths of each platform to optimize cost, performance, and resilience.',
    icon: Cloudy,
    features: ['Cloud Readiness Assessment', 'Vendor Selection & Management', 'Cost Optimization Planning', 'Hybrid Cloud Architecture'],
  },
  {
    title: 'Cloud Migration & Deployment',
    description: 'Seamlessly migrate your applications, data, and infrastructure to the cloud with minimal downtime. We ensure a smooth transition and deployment.',
    icon: Rocket,
    features: ['Lift-and-Shift Migration', 'Re-platforming & Re-architecting', 'Automated Deployment Pipelines', 'Post-Migration Support'],
  },
  {
    title: 'Cloud-Native Development',
    description: 'Build scalable, resilient, and modern applications using cloud-native technologies like containers, serverless functions, and microservices.',
    icon: ServerCog,
    features: ['Microservices Architecture', 'Docker & Kubernetes (EKS, GKE, AKS)', 'Serverless Computing (Lambda, Functions)', 'API Development & Management'],
  },
  {
    title: 'DevOps & Automation',
    description: 'Accelerate your development lifecycle and improve operational efficiency with our DevOps and automation services, from CI/CD to infrastructure as code.',
    icon: GitMerge,
    features: ['CI/CD Pipeline Implementation', 'Infrastructure as Code (Terraform)', 'Configuration Management (Ansible)', 'Monitoring & Logging Solutions'],
  },
  {
    title: 'Data Engineering using Cloud',
    description: 'Build scalable and reliable data pipelines and data warehouses on the cloud to power your analytics and AI initiatives.',
    icon: DatabaseZap,
    features: ['ETL/ELT Pipeline Development', 'Data Warehouse Modernization (BigQuery, Redshift, Snowflake)', 'Data Lake Architecture', 'Real-time Data Streaming'],
  },
  {
    title: 'AI & Machine Learning Cloud Services',
    description: 'Leverage the power of AI with cloud-native machine learning services to build, train, and deploy models at scale for intelligent applications.',
    icon: BrainCircuit,
    features: ['Custom Model Development', 'Managed AI Platforms (SageMaker, Vertex AI)', 'Natural Language Processing (NLP)', 'Computer Vision Solutions'],
  },
];

export default function CloudConsultancyPage() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="relative w-full py-20 md:py-32 lg:py-40 flex items-center justify-center text-center text-white">
        <Image
          src="/cloudconsultancy.png"
          alt="Cloud Consultancy"
          fill
          priority
          className="object-cover -z-10 brightness-50"
        />
        <div className="container px-4 md:px-6">
          <div className="flex flex-col items-center space-y-4">
            <h1 className="text-4xl font-bold tracking-tighter sm:text-5xl xl:text-6xl/none font-headline">
              Cloud Consultancy Services
            </h1>
            <p className="max-w-[700px] text-lg md:text-xl">
              Leverage the power of the cloud. We provide expert guidance and solutions for AWS, Google Cloud, and Azure to fuel your business growth.
            </p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-secondary">
        <div className="container px-4 md:px-6">
          <div className="text-center">
            <h2 className="text-3xl font-bold tracking-tighter sm:text-5xl font-headline">Our Cloud Services</h2>
            <p className="max-w-[900px] mx-auto text-muted-foreground md:text-xl/relaxed mt-4">
              From strategy and migration to cloud-native development, we offer a complete suite of services to help you succeed in the cloud.
            </p>
          </div>
          <div className="mx-auto grid grid-cols-1 gap-8 py-12 sm:grid-cols-2 lg:grid-cols-3">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="flex flex-col transition-transform transform hover:-translate-y-2">
                  <CardHeader>
                    <div className="flex items-center gap-4">
                      <div className="bg-primary/10 rounded-full p-3 w-fit">
                        <Icon className="h-8 w-8 text-primary" />
                      </div>
                      <CardTitle className="font-headline text-2xl">{service.title}</CardTitle>
                    </div>
                  </CardHeader>
                  <CardContent className="flex-grow flex flex-col">
                    <p className="text-muted-foreground mb-6">{service.description}</p>
                    <ul className="space-y-3 flex-grow">
                      {service.features.map((feature, fIndex) => (
                         <li key={fIndex} className="flex items-start gap-3">
                            <Check className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                            <span className="text-muted-foreground">{feature}</span>
                        </li>
                      ))}
                    </ul>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-background">
        <div className="container text-center">
            <h2 className="text-3xl md:text-4xl font-bold font-headline">Ready to Scale with the Cloud?</h2>
            <p className="mt-4 max-w-2xl mx-auto text-muted-foreground">
              Let's discuss your cloud strategy and how we can help you innovate faster. Contact us for a free consultation.
            </p>
            <div className="mt-8 flex flex-col sm:flex-row items-center justify-center gap-4">
                <Button size="lg" asChild>
                  <Link href="https://calendly.com/riteclick/new-meeting" target="_blank" rel="noopener noreferrer">
                    Schedule a Free Consultation <LinkIcon className="ml-2" />
                  </Link>
                </Button>
                <Button size="lg" variant="outline" asChild>
                    <a href="https://wa.me/2349115572489" target="_blank" rel="noopener noreferrer">
                        <MessageCircle className="mr-2" /> Chat on WhatsApp
                    </a>
                </Button>
            </div>
        </div>
      </section>
    </div>
  );
}
