
import type { Metadata } from 'next';

export const metadata: Metadata = {
    title: 'Privacy Policy | RiteClick Technology',
    description: 'Privacy Policy for RiteClick Technology. Learn how we collect, use, and share data.',
};

export default function PrivacyPolicyPage() {
  return (
    <div className="container py-12 md:py-24">
      <article className="prose prose-lg mx-auto max-w-4xl">
        <h1 className="text-3xl md:text-5xl font-bold font-headline mb-8 text-center">RiteClick Technology Privacy Policy</h1>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Introduction</h2>
          <p>
            RiteClick Technology, together with its subsidiaries and international affiliates
            ("RiteClick Technology", "we", "us"), respects your privacy and outlines how we
            collect, use, and share data about you through our online platforms,
            including our website and mobile application. This Privacy Policy is in
            accordance with applicable data protection laws, including the General
            Data Protection Regulations, 2018.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Scope</h2>
          <p>
            This Privacy Policy applies when you use RiteClick Technology's website, mobile
            applications, APIs, or related services (the “Services”). By using our
            Services, you agree to the terms of this Privacy Policy and our Terms of
            Use.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Data Controller</h2>
          <p>
            The entity responsible for your data depends on where it is collected.
            RiteClick Technology may share data with its affiliates and may transfer data as
            part of business transactions.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Legal Basis for Processing Data</h2>
          <p>
            We process your data based on your consent, for contractual obligations,
            our legitimate interests, compliance with legal obligations, and in the
            public interest. Consent can be withdrawn, but it may affect our ability to
            provide services.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Data We Collect</h2>
          <h3 className="text-xl font-bold font-headline mt-4">1. Data You Provide:</h3>
          <ul className="list-disc pl-6 space-y-2 mt-2">
            <li><strong>Account and Profile Data:</strong> Name, email, password, contact details, educational qualifications, etc.</li>
            <li><strong>Payment Data:</strong> Name, payment details.</li>
            <li><strong>Course Participation Data:</strong> Data about your participation in courses and programs.</li>
            <li><strong>Communications and Support Data:</strong> Support queries and communications.</li>
          </ul>
          <h3 className="text-xl font-bold font-headline mt-4">2. Data We Collect Automatically:</h3>
          <ul className="list-disc pl-6 space-y-2 mt-2">
            <li><strong>System Data:</strong> IP address, device type, operating system, etc.</li>
            <li><strong>Usage Data:</strong> Interactions with our Services.</li>
            <li><strong>Geographic Data:</strong> Approximate geographic location.</li>
          </ul>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Use of Data</h2>
          <p>We use your data to:</p>
          <ul className="list-disc pl-6 space-y-2 mt-2">
            <li>Provide and improve our Services.</li>
            <li>Communicate with you.</li>
            <li>Process payments.</li>
            <li>Ensure security.</li>
            <li>Comply with legal obligations.</li>
          </ul>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Sharing Data</h2>
          <p>We share data with:</p>
          <ul className="list-disc pl-6 space-y-2 mt-2">
            <li>Educational partners.</li>
            <li>Service providers (e.g., payment processors).</li>
            <li>Business partners.</li>
            <li>Analytics and advertising providers.</li>
            <li>For legal compliance and safety.</li>
          </ul>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Security</h2>
          <p>
            We use appropriate security measures to protect your data. However, no
            system is completely secure, so it's important to protect your password
            and notify us of any unauthorized access.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Your Rights</h2>
          <p>
            You have rights to access, correct, delete, and restrict the processing of
            your data. You can also opt out of certain data uses, such as promotional
            communications.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Children’s Privacy</h2>
          <p>
            Our Services are not intended for children under 13. We do not knowingly
            collect data from children under 13 without parental consent.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Jurisdiction-Specific Rules</h2>
          <p>
            West African residents have additional rights regarding their personal
            information. Users outside the West Africa consent to the transfer of their
            data to Nigeria.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Updates</h2>
          <p>
            We may update this Privacy Policy and will notify users of material
            changes.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Contact Us</h2>
          <p>For questions or concerns about this Privacy Policy, contact us at:</p>
          <address className="not-italic mt-2">
            RiteClick Technology<br />
            Legal Department<br />
            Email: <a href="mailto:info@riteclick.com.ng" className="text-primary hover:underline">info@riteclick.com.ng</a>
          </address>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Cookie Policy</h2>
          <p>
            We use cookies and similar technologies to deliver, measure, and improve
            our Services. You can control cookies through your browser settings.
          </p>
        </section>

        <section className="mb-8">
          <h2 className="text-2xl font-bold font-headline">Payment Fraud Prevention</h2>
          <p>
            All payments should be made through RiteClick Technology’s official platform. Any
            suspicious requests should be reported.
          </p>
        </section>

        <section>
          <h2 className="text-2xl font-bold font-headline">Governing Law</h2>
          <p>
            This Privacy Policy is governed by the laws of Federal Republic of Nigeria.
          </p>
        </section>

      </article>
    </div>
  );
}
