
import type { Metadata } from 'next';
import './globals.css';
import { cn } from '@/lib/utils';
import { Header } from '@/components/layout/header';
import { Footer } from '@/components/layout/footer';
import { Toaster } from "@/components/ui/toaster";
import { BackToTopButton } from '@/components/back-to-top';
import { CookieConsent } from '@/components/cookie-consent';

export const metadata: Metadata = {
  title: 'RiteClick Technology - Master In-Demand Tech Skills',
  description:
    'Join RiteClick Technology to master Cloud Computing, Data Science, AI, Data Analysis, and Cyber Security in 3 months. Beginner-friendly, career-oriented virtual training.',
  icons: {
    icon: '/logo.png',
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" className="scroll-smooth">
      <head>
        <link rel="icon" href="/logo.png" sizes="any" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossOrigin="anonymous" />
        <link href="https://fonts.googleapis.com/css2?family=PT+Sans:wght@400;700&display=swap" rel="stylesheet" />
      </head>
      <body
        className={cn(
          'min-h-screen bg-background font-body antialiased'
        )}
      >
          <Header />
          <main className="flex-1">{children}</main>
          <Footer />
          <Toaster />
          <BackToTopButton />
          <CookieConsent />
      </body>
    </html>
  );
}
